﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Demo.DataModel;

namespace Demo.PresentationModel
{
    public class CustomerPresentationModel : PresentationModel<Customer>, ICustomerPresentation
    {
        ICustomerService service = new CustomerService();

        private string searchText;
        public string SearchText
        {
            get { return searchText; }
            set 
            { 
                searchText = value; 
                NotifyPropertyChanged("Items");
                NotifyPropertyChanged("ItemCount"); 
            }
        }

        protected override IEnumerable<Customer> GetItems()
        {
            //Option 1: Retrieve customer collection from service all the time
            //if (items == null)
            //{
            //    items = string.IsNullOrEmpty(SearchText) ?
            //        service.GetAllCustomers() :
            //        service.GetSearchCustomers(SearchText);

            //    ItemCount = items.Count();
            //}
            //return items;

            //Option 2: Cache customer collection on client side
            if (items == null)
            {
                items = service.GetAllCustomers();
            }

            string txt = SearchText == null ? null : SearchText.ToLower();
            var newitems = string.IsNullOrEmpty(txt) ? items :

                from customer in items
                where customer.FirstName.ToLower().Contains(txt) ||
                      customer.LastName.ToLower().Contains(txt) ||
                      customer.Address.ToLower().Contains(txt)
                select customer;

            itemCount = newitems.Count();

            return newitems;
        }
    }
}
